<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resturant extends Model 
{

    protected $table = 'resturants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'password', 'minmum_order', 'delivery_fee', 'communication_phone', 'whats_up', 'resturant_image', 'status', 'city_id', 'neighborhood_id');
    protected $hidden = array('password');

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function neighborhood()
    {
        return $this->belongsTo('App\Models\Neighborhood');
    }

    public function categories()
    {
        return $this->belongsToMany('App\Models\Category');
    }

    public function foods()
    {
        return $this->belongsToMany('App\Models\Food');
    }

    public function comments()
    {
        return $this->hasMany('App\Models\Comment');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer');
    }

    public function carts()
    {
        return $this->hasMany('App\Models\Cart');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function commission()
    {
        return $this->hasOne('App\Models\Commission');
    }

}